import pickle
import numpy as np
from d4rl import get_normalized_score
from train_offline import normalize

filenames = ['hopper-random+expert-v2-inf-0.9_dataset.pt'] #'relocate-cloned+expert-v0-30-0.9_dataset.pt']
for filename in filenames:
    with open(filename, 'rb') as fp:
        (expert_dataset, _, _) = pickle.load(fp)
        
        ret = 0
        norm_rets = []
        rets = []
        for i in range(expert_dataset.size):
            reward = expert_dataset.rewards[i]
            done = expert_dataset.dones_float[i]
            ret += reward
            if done == 1.:
                env_name = filename.split('+expert')[0] + '-' + filename.split('+expert-')[1].split('-')[0]
                print(env_name)
                norm_rets.append(get_normalized_score(env_name, ret) * 100.0)
                rets.append(ret)
                print(norm_rets[-1])
                ret = 0
         
        print(filename, len(norm_rets), np.mean(norm_rets), np.mean(rets)) 
        